<?php

namespace EFFE_Plugin;

/**
 * Useful utilities.
 *
 * @since      1.0.0
 * @package    Event_Feed_For_Eventbrite
 * @subpackage Event_Feed_For_Eventbrite/includes
 * @author     Bohemia Plugins <https://www.bohemiaplugins.com>
 * 			   Fullworks <https://fullworks.net/>
 */
class Event_Feed_For_Eventbrite_Utilities {

    protected static $instance;
    private $plugin_name;
    
    /**
     * Utilities constructor.
     */
    public function __construct()
    {
        $this->plugin_name = 'event-feed-for-eventbrite';
    }

    /**
     * @return Utilities
     */
    public static function get_instance()
    {
        if ( null == self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function get_api_error_string( $error_string ) {
        do {
            $error_string = $error_string->get_error_message();
        } while (is_wp_error( $error_string ));
        
        if ( is_array( $error_string ) ) {
            $text = json_decode( $error_string['body'] );
            
            if ( null !== $text ) {
                $error_string = $text->error_description;
            } else {
                if ( isset( $error_string['response'] ) ) {
                    $error_string = esc_html__( 'Error code from Eventbrite was' ) . ':' . $error_string['response']['code'] . ' ' . esc_html__( 'Error message' ) . ':' . $error_string['response']['message'];
                }
            }
        
        }
        
        return $error_string;
    }

}