<?php

// Get the event feed post meta
$display_public             = get_post_meta( $post->ID, 'display_public', true );
$display_private            = get_post_meta( $post->ID, 'display_private', true );
$display_venue              = get_post_meta( $post->ID, 'display_venue', true );
$display_online             = get_post_meta( $post->ID, 'display_online', true );
$time_filter                = get_post_meta( $post->ID, 'time_filter', true );
$name_filter                = get_post_meta( $post->ID, 'name_filter', true );
$location_filter            = get_post_meta( $post->ID, 'location_filter', true );

?>

<div class="event-feed-for-eventbrite-metabox-content event-feed-for-eventbrite-filters-metabox">

    <!-- Time Filter -->
    <div class="event-feed-for-eventbrite-metabox-field">
        <div class="event-feed-for-eventbrite-metabox-label">
            <label class="effe-pro-feature" data-service="<?php esc_attr_e( 'Time Filter', 'event-feed-for-eventbrite' ); ?>" data-upgrade-link="<?php echo esc_url( $this->freemius->get_upgrade_url() ); ?>">
                <?php esc_html_e( 'Time Filter', 'event-feed-for-eventbrite' ); ?>
            </label>
            <p class="description"><?php esc_html_e( 'Choose if you want to display current, past, or all events in this feed.', 'event-feed-for-eventbrite' ); ?></p>
        </div>

        <div class="event-feed-for-eventbrite-metabox-input">

            <div class="select-wrapper effe-pro-feature" data-service="<?php esc_attr_e( 'Time Filter', 'event-feed-for-eventbrite' ); ?>" data-upgrade-link="<?php echo esc_url( $this->freemius->get_upgrade_url() ); ?>">
                <select id="<?php echo esc_attr( $this->plugin_name . '-time_filter' ); ?>" name="<?php echo esc_attr( $this->plugin_name . '[time_filter]' ); ?>" class="small-text choices-time-filter" <?php if( ! $this->freemius->can_use_premium_code() || $this->freemius->is_free_plan() ) { echo 'disabled'; } ?>>
                    <option value="current_future" <?php if( $time_filter == 'current_future' ) { echo 'selected'; } ?>>
                        <?php esc_html_e( 'Current and future events', 'event-feed-for-eventbrite'); ?>
                    </option>
                    <option value="past" <?php if( $time_filter == 'past' ) { echo 'selected'; } ?>>
                        <?php esc_html_e( 'Past events', 'event-feed-for-eventbrite'); ?>
                    </option>
                </select>
            </div>

            <?php if( ( ! $this->freemius->can_use_premium_code() || $this->freemius->is_free_plan() ) && ( get_post_status ( $post->ID ) !== 'auto-draft' ) && ( $time_filter == 'past' || $time_filter == 'all' ) ) { ?>
            <div class="event-feed-for-eventbrite-warning">
                <div>
                    <div><?php
                    printf(
                        '%s <strong>%s</strong>. <br>%s <a href="' . esc_url( $this->freemius->get_upgrade_url() ) . '">' . esc_html__( 'renew your license', 'event-feed-for-eventbrite' ) . '</a>.',
                        esc_html__( 'Time filter can\'t be applied, because', 'event-feed-for-eventbrite' ) ,
                        esc_html__( 'your premium license is not active', 'event-feed-for-eventbrite' ),
                        esc_html__( 'To continue using this feature, please', 'event-feed-for-eventbrite' )
                    );
                    ?></div>
                </div>
            </div>
            <?php } ?>

        </div>  
    </div>

    <!-- Privacy Filter -->
    <div class="event-feed-for-eventbrite-metabox-field">
        <div class="event-feed-for-eventbrite-metabox-label">
            <label>
                <?php esc_html_e( 'Privacy Filter', 'event-feed-for-eventbrite' ); ?>
            </label>
            <p class="description"><?php esc_html_e( 'Choose if you want to display public or/and private events.', 'event-feed-for-eventbrite' ); ?></p>
        </div>
        <div class="event-feed-for-eventbrite-metabox-input">

            <fieldset>

                <!-- Public Events -->
                <input type="checkbox" class="effe-pro-feature" id="<?php echo esc_attr( $this->plugin_name . '-display_public' ); ?>" name="<?php echo esc_attr( $this->plugin_name . '[display_public]' ); ?>" value="1" <?php if( $display_public == 1 || get_post_status ( $post->ID ) === 'auto-draft' ) { echo 'checked'; } ?> <?php if( ! $this->freemius->can_use_premium_code() || $this->freemius->is_free_plan() ) { echo 'readonly'; } ?> data-service="<?php esc_attr_e( 'Privacy Filter', 'event-feed-for-eventbrite' ); ?>" data-upgrade-link="<?php echo esc_url( $this->freemius->get_upgrade_url() ); ?>">
                <label for="<?php echo esc_attr( $this->plugin_name . '-display_public' ); ?>" class="effe-pro-feature" data-service="<?php esc_attr_e( 'Privacy Filter', 'event-feed-for-eventbrite' ); ?>" data-upgrade-link="<?php echo esc_url( $this->freemius->get_upgrade_url() ); ?>"><?php esc_html_e( 'Public Events', 'event-feed-for-eventbrite' ); ?></label><br>

                <!-- Private Events -->
                <input type="checkbox" class="effe-pro-feature" id="<?php echo esc_attr( $this->plugin_name . '-display_private' ); ?>" name="<?php echo esc_attr( $this->plugin_name . '[display_private]' ); ?>" value="1" <?php if( $display_private == 1 || get_post_status ( $post->ID ) === 'auto-draft' ) { echo 'checked'; } ?> <?php if( ! $this->freemius->can_use_premium_code() || $this->freemius->is_free_plan() ) { echo 'readonly'; } ?> data-service="<?php esc_attr_e( 'Privacy Filter', 'event-feed-for-eventbrite' ); ?>" data-upgrade-link="<?php echo esc_url( $this->freemius->get_upgrade_url() ); ?>">
                <label for="<?php echo esc_attr( $this->plugin_name . '-display_private' ); ?>" class="effe-pro-feature" data-service="<?php esc_attr_e( 'Privacy Filter', 'event-feed-for-eventbrite' ); ?>" data-upgrade-link="<?php echo esc_url( $this->freemius->get_upgrade_url() ); ?>"><?php esc_html_e( 'Private Events', 'event-feed-for-eventbrite' ); ?></label><br>

            </fieldset>

            <?php if( ( ! $this->freemius->can_use_premium_code() || $this->freemius->is_free_plan() ) && ( get_post_status ( $post->ID ) !== 'auto-draft' ) && ( $display_public == 0 || $display_private == 0 ) ) { ?>
            <div class="event-feed-for-eventbrite-warning">
                <div>
                    <div><?php
                    printf(
                        '%s <strong>%s</strong>. <br>%s <a href="' . esc_url( $this->freemius->get_upgrade_url() ) . '">' . esc_html__( 'renew your license', 'event-feed-for-eventbrite' ) . '</a>.',
                        esc_html__( 'Privacy filter can\'t be applied, because', 'event-feed-for-eventbrite' ) ,
                        esc_html__( 'your premium license is not active', 'event-feed-for-eventbrite' ),
                        esc_html__( 'To continue using this feature, please', 'event-feed-for-eventbrite' )
                    );
                    ?></div>
                </div>
            </div>
            <?php } ?>

        </div>
    </div>

    <!-- Venue Filter -->
    <div class="event-feed-for-eventbrite-metabox-field">
        <div class="event-feed-for-eventbrite-metabox-label">
            <label class="effe-pro-feature" data-service="<?php esc_attr_e( 'Venue Filter', 'event-feed-for-eventbrite' ); ?>" data-upgrade-link="<?php echo esc_url( $this->freemius->get_upgrade_url() ); ?>">
                <?php esc_html_e( 'Venue Filter', 'event-feed-for-eventbrite' ); ?>
            </label>
            <p class="description"><?php esc_html_e( 'Choose if you want to display events with a venue or/and online events.', 'event-feed-for-eventbrite' ); ?></p>
        </div>
        <div class="event-feed-for-eventbrite-metabox-input">

            <fieldset>

                <!-- Events with venue -->
                <input type="checkbox" class="effe-pro-feature" id="<?php echo esc_attr( $this->plugin_name . '-display_venue' ); ?>" name="<?php echo esc_attr( $this->plugin_name . '[display_venue]' ); ?>" value="1" <?php if( $display_venue == 1 || get_post_status ( $post->ID ) === 'auto-draft' ) { echo 'checked'; } ?> <?php if( ! $this->freemius->can_use_premium_code() || $this->freemius->is_free_plan() ) { echo 'readonly'; } ?> data-service="<?php esc_attr_e( 'Venue Filter', 'event-feed-for-eventbrite' ); ?>" data-upgrade-link="<?php echo esc_url( $this->freemius->get_upgrade_url() ); ?>">
                <label for="<?php echo esc_attr( $this->plugin_name . '-display_venue' ); ?>" class="effe-pro-feature" data-service="<?php esc_attr_e( 'Venue Filter', 'event-feed-for-eventbrite' ); ?>" data-upgrade-link="<?php echo esc_url( $this->freemius->get_upgrade_url() ); ?>"><?php esc_html_e( 'Events with Venue', 'event-feed-for-eventbrite' ); ?></label><br>

                <!-- Online events -->
                <input type="checkbox" class="effe-pro-feature" id="<?php echo esc_attr( $this->plugin_name . '-display_online' ); ?>" name="<?php echo esc_attr( $this->plugin_name . '[display_online]' ); ?>" value="1" <?php if( $display_online == 1 || get_post_status ( $post->ID ) === 'auto-draft' ) { echo 'checked'; } ?> <?php if( ! $this->freemius->can_use_premium_code() || $this->freemius->is_free_plan() ) { echo 'readonly'; } ?> data-service="<?php esc_attr_e( 'Venue Filter', 'event-feed-for-eventbrite' ); ?>" data-upgrade-link="<?php echo esc_url( $this->freemius->get_upgrade_url() ); ?>">
                <label for="<?php echo esc_attr( $this->plugin_name . '-display_online' ); ?>" class="effe-pro-feature" data-service="<?php esc_attr_e( 'Venue Filter', 'event-feed-for-eventbrite' ); ?>" data-upgrade-link="<?php echo esc_url( $this->freemius->get_upgrade_url() ); ?>"><?php esc_html_e( 'Online Events', 'event-feed-for-eventbrite' ); ?></label><br>

            </fieldset>

            <?php if( ( ! $this->freemius->can_use_premium_code() || $this->freemius->is_free_plan() ) && ( get_post_status ( $post->ID ) !== 'auto-draft' ) && ( $display_venue == 0 || $display_online == 0 ) ) { ?>
            <div class="event-feed-for-eventbrite-warning">
                <div>
                    <div><?php
                    printf(
                        '%s <strong>%s</strong>. <br>%s <a href="' . esc_url( $this->freemius->get_upgrade_url() ) . '">' . esc_html__( 'renew your license', 'event-feed-for-eventbrite' ) . '</a>.',
                        esc_html__( 'Venue filter can\'t be applied, because', 'event-feed-for-eventbrite' ) ,
                        esc_html__( 'your premium license is not active', 'event-feed-for-eventbrite' ),
                        esc_html__( 'To continue using this feature, please', 'event-feed-for-eventbrite' )
                    );
                    ?></div>
                </div>
            </div>
            <?php } ?>
            
        </div>        
    </div>

    <!-- Name Filter -->
    <div class="event-feed-for-eventbrite-metabox-field">
        <div class="event-feed-for-eventbrite-metabox-label">
            <label for="<?php echo esc_attr( $this->plugin_name . '-name_filter' ); ?>" class="effe-pro-feature" data-service="<?php esc_attr_e( 'Name Filter', 'event-feed-for-eventbrite' ); ?>" data-upgrade-link="<?php echo esc_url( $this->freemius->get_upgrade_url() ); ?>">
                <?php esc_html_e( 'Name Filter', 'event-feed-for-eventbrite' ); ?>
            </label>
            <p class="description"><?php esc_html_e( 'Show only events whose name contains specific text.', 'event-feed-for-eventbrite' ); ?></p>
        </div>
        <div class="event-feed-for-eventbrite-metabox-input">
            <div>
                <input type="text" class="effe-pro-feature" id="<?php echo esc_attr( $this->plugin_name . '-name_filter' ); ?>" name="<?php echo esc_attr( $this->plugin_name . '[name_filter]' ); ?>" value="<?php echo esc_attr( $name_filter ); ?>" <?php if( ! $this->freemius->can_use_premium_code() || $this->freemius->is_free_plan() ) { echo 'readonly'; } ?> data-service="<?php esc_attr_e( 'Name Filter', 'event-feed-for-eventbrite' ); ?>" data-upgrade-link="<?php echo esc_url( $this->freemius->get_upgrade_url() ); ?>">
            </div>

            <?php if( ( ! $this->freemius->can_use_premium_code() || $this->freemius->is_free_plan() ) && $name_filter !== '' ) { ?>
            <div class="event-feed-for-eventbrite-warning">
                <div>
                    <div><?php
                    printf(
                        '%s <strong>%s</strong>. <br>%s <a href="' . esc_url( $this->freemius->get_upgrade_url() ) . '">' . esc_html__( 'renew your license', 'event-feed-for-eventbrite' ) . '</a>.',
                        esc_html__( 'Name filter can\'t be applied, because', 'event-feed-for-eventbrite' ) ,
                        esc_html__( 'your premium license is not active', 'event-feed-for-eventbrite' ),
                        esc_html__( 'To continue using this feature, please', 'event-feed-for-eventbrite' )
                    );
                    ?></div>
                </div>
            </div>
            <?php } ?>

        </div>     
    </div>

    <!-- Location Filter -->
    <div class="event-feed-for-eventbrite-metabox-field">
        <div class="event-feed-for-eventbrite-metabox-label">
            <label for="<?php echo esc_attr( $this->plugin_name . '-location_filter' ); ?>" class="effe-pro-feature" data-service="<?php esc_attr_e( 'Location Filter', 'event-feed-for-eventbrite' ); ?>" data-upgrade-link="<?php echo esc_url( $this->freemius->get_upgrade_url() ); ?>">
                <?php esc_html_e( 'Location Filter', 'event-feed-for-eventbrite' ); ?>
            </label>
            <p class="description"><?php esc_html_e( 'Show only events whose location contains specific text.', 'event-feed-for-eventbrite' ); ?></p>
        </div>
        <div class="event-feed-for-eventbrite-metabox-input">
            <div>
                <input type="text" class="effe-pro-feature" id="<?php echo esc_attr( $this->plugin_name . '-location_filter' ); ?>" name="<?php echo esc_attr( $this->plugin_name . '[location_filter]' ); ?>" value="<?php echo esc_attr( $location_filter ); ?>" <?php if( ! $this->freemius->can_use_premium_code() || $this->freemius->is_free_plan() ) { echo 'readonly'; } ?> data-service="<?php esc_attr_e( 'Location Filter', 'event-feed-for-eventbrite' ); ?>" data-upgrade-link="<?php echo esc_url( $this->freemius->get_upgrade_url() ); ?>">
            </div>

            <?php if( ( ! $this->freemius->can_use_premium_code() || $this->freemius->is_free_plan() ) && $location_filter !== '' ) { ?>
            <div class="event-feed-for-eventbrite-warning">
                <div>
                    <div><?php
                    printf(
                        '%s <strong>%s</strong>. <br>%s <a href="' . esc_url( $this->freemius->get_upgrade_url() ) . '">' . esc_html__( 'renew your license', 'event-feed-for-eventbrite' ) . '</a>.',
                        esc_html__( 'Location filter can\'t be applied, because', 'event-feed-for-eventbrite' ) ,
                        esc_html__( 'your premium license is not active', 'event-feed-for-eventbrite' ),
                        esc_html__( 'To continue using this feature, please', 'event-feed-for-eventbrite' )
                    );
                    ?></div>
                </div>
            </div>
            <?php } ?>

        </div>     
    </div>
    
</div>